function[motF] = MotorLoad(motT, motX, cX, kin1, kin2, kin3, DDB, dyn)
motF = zeros(1,length(motT)); % initialize

for mm = 1:length(motT)
    switch motT(mm)
        case 1 % kin-1
            motF(mm) = kin1.stiff*(cX - motX(mm));
        case 2 % kin-2
            motF(mm) = kin2.stiff*(cX - motX(mm));
        case 3 % kin-3
            motF(mm) = kin3.stiff*(cX - motX(mm));
        case 4 % DDB
            motF(mm) = DDB.stiff*(cX - motX(mm));
        case 5 % dyn
            motF(mm) = dyn.stiff*(cX - motX(mm));
    end
end
end